export declare class TPoint {
    x: number;
    y: number;
    protected constructor(x: number, y: number);
    static from(point: {
        x: number;
        y: number;
    }): TPoint;
    SetPoint(x: number, y: number): void;
    SetLocation(x: number, y: number): void;
    Equals(other: TPoint): boolean;
    toString(): string;
}
export declare class TRect {
    left: number;
    top: number;
    right: number;
    bottom: number;
    protected constructor(left: number, top: number, right: number, bottom: number);
    get Width(): number;
    get Height(): number;
    IsValidForDrawing(): boolean;
    DoSetRect(left: number, top: number, right: number, bottom: number): void;
    InflateRect(left: number, top: number, right: number, bottom: number): void;
    PtInRect(point: TPoint): boolean;
    PtInRect_numbers(x: number, y: number): boolean;
    Intersect(rect: TRect): TRect;
    Union(rect: TRect): TRect;
    IsEmpty(): boolean;
    Equals(rect: TRect): boolean;
    Contains(rect: TRect): boolean;
    static SetRect(left: number, top: number, right: number, bottom: number): TRect;
    Inflate(dx: number, dy: number): void;
    Copy(): TRect;
}
export declare enum TPenStyle {
    SOLID = 0,
    DASH = 1,
    DOT = 2,
    DASH_DOT = 3,
    DASH_DOT_DOT = 4,
    CLEAR = 5,
    INSIDE_FRAME = 6,
    USER_STYLE = 7,
    ALTERNATE = 8
}
export declare class TChartInfo {
    firstIndex: number;
    lastIndex: number;
    paintRect: TRect;
    barWidth: number;
    currZoom: number;
    protected constructor();
}
export declare enum TDrawStyle {
    LINE = 0,
    HISTOGRAM = 1,
    FILL = 2,
    SYMBOL = 3,
    SECTION = 4,
    HISTOGRAM_FILL = 5,
    COLORED_CANDLES = 6,
    NONE = 7
}
export declare enum TTradePositionType {
    BUY = 0,
    SELL = 1,
    BUY_LIMIT = 2,
    SELL_LIMIT = 3,
    BUY_STOP = 4,
    SELL_STOP = 5,
    DEPOSIT = 6,
    WITHDRAWAL = 7,
    CREDIT = 8,
    CANCELLED = 9
}
export type TColor$1 = string;
export declare class TLineStyleRec {
    color: TColor$1;
    style: TPenStyle;
    width: number;
    DrawingStyle: TDrawStyle;
    Symbol: number;
    xoffs: number;
    yoffs: number;
    protected constructor();
    GetShortStr(isNeedToShowLineProperties: boolean): string;
    SetShortStr(s: string): void;
}
export declare enum ENUM_SYMBOL_INFO_NUMBER {
    SYMBOL_PRICE_BID = 0,
    SYMBOL_PRICE_ASK = 1,
    SYMBOL_POINT_VALUE = 2,
    SYMBOL_TICK_VALUE = 3,
    SYMBOL_TICK_SIZE = 4,
    SYMBOL_CONTRACT_SIZE = 5,
    SYMBOL_MIN_VOLUME = 6,
    SYMBOL_MAX_VOLUME = 7,
    SYMBOL_VOLUME_STEP_SIZE = 8,
    SYMBOL_SWAP_LONG_RATE = 9,
    SYMBOL_SWAP_SHORT_RATE = 10,
    SYMBOL_INITIAL_MARGIN = 11,
    SYMBOL_MAINTENANCE_MARGIN = 12,
    SYMBOL_IS_SELECTED = 13,
    SYMBOL_IS_VISIBLE = 14,
    SYMBOL_LAST_QUOTE_TIME = 15,
    SYMBOL_DECIMAL_PLACES = 16,
    SYMBOL_FLOATING_SPREAD = 17,
    SYMBOL_CURRENT_SPREAD = 18,
    SYMBOL_PROFIT_CALCULATION_MODE = 19,
    SYMBOL_TRADING_MODE = 20,
    SYMBOL_TRADING_START_TIME = 21,
    SYMBOL_ORDER_EXPIRATION_TIME = 22,
    SYMBOL_STOPS_LEVEL = 23,
    SYMBOL_FREEZE_LEVEL = 24,
    SYMBOL_SWAP_CALCULATION_MODE = 25,
    SYMBOL_SWAP_TRIPLE_DAY = 26
}
export declare enum ENUM_SYMBOL_INFO_STRING {
    SYMBOL_BASE_CURRENCY = 0,
    SYMBOL_PROFIT_CURRENCY = 1,
    SYMBOL_MARGIN_CURRENCY = 2,
    SYMBOL_DISPLAY_NAME = 3,
    SYMBOL_MARKET_PATH = 4
}
export declare enum ENUM_TIMEFRAMES {
    TIMEFRAME_CURRENT = 0,// Current timeframe
    TIMEFRAME_M1 = 1,// 1 minute
    TIMEFRAME_M5 = 2,// 5 minutes
    TIMEFRAME_M15 = 3,// 15 minutes
    TIMEFRAME_M30 = 4,// 30 minutes
    TIMEFRAME_H1 = 5,// 1 hour
    TIMEFRAME_H4 = 6,// 4 hours
    TIMEFRAME_D1 = 7,// 1 day
    TIMEFRAME_W1 = 8,// 1 week
    TIMEFRAME_MN1 = 9,// 1 month
    TIMEFRAME_M2 = 10,// 2 minutes
    TIMEFRAME_M3 = 11,// 3 minutes
    TIMEFRAME_M4 = 12,// 4 minutes
    TIMEFRAME_M6 = 13,// 6 minutes
    TIMEFRAME_M10 = 14,// 10 minutes
    TIMEFRAME_M12 = 15,// 12 minutes
    TIMEFRAME_M20 = 16,// 20 minutes
    TIMEFRAME_H2 = 17,// 2 hours
    TIMEFRAME_H3 = 18,// 3 hours
    TIMEFRAME_H6 = 19,// 6 hours
    TIMEFRAME_H8 = 20,// 8 hours
    TIMEFRAME_H12 = 21
}
export declare enum ENUM_STATISTICS {
    STAT_STARTING_DEPOSIT = 0,
    STAT_NET_PROFIT = 1,
    STAT_TOTAL_GROSS_PROFIT = 2,
    STAT_TOTAL_GROSS_LOSS = 3,
    STAT_LARGEST_PROFIT = 4,
    STAT_LARGEST_LOSS = 5,
    STAT_CONSECUTIVE_PROFITS_MAX = 6,
    STAT_CONSECUTIVE_PROFITS_MAX_COUNT = 7,
    STAT_MAX_CONSECUTIVE_WINS = 8,
    STAT_MAX_CONSECUTIVE_PROFIT_COUNT = 9,
    STAT_CONSECUTIVE_LOSSES_MAX = 10,
    STAT_CONSECUTIVE_LOSSES_MAX_COUNT = 11,
    STAT_MAX_CONSECUTIVE_LOSSES = 12,
    STAT_MAX_CONSECUTIVE_LOSS_COUNT = 13,
    STAT_BALANCE_MINIMUM = 14,
    STAT_BALANCE_DRAWDOWN = 15,
    STAT_BALANCE_DRAWDOWN_PERCENT = 16,
    STAT_BALANCE_DRAWDOWN_REL_PERCENT = 17,
    STAT_BALANCE_DRAWDOWN_RELATIVE = 18,
    STAT_EQUITY_MINIMUM = 19,
    STAT_EQUITY_DRAWDOWN = 20,
    STAT_EQUITY_DRAWDOWN_PERCENT = 21,
    STAT_EQUITY_DRAWDOWN_REL_PERCENT = 22,
    STAT_EQUITY_DRAWDOWN_RELATIVE = 23,
    STAT_EXPECTED_PROFIT = 24,
    STAT_PROFITABILITY_FACTOR = 25,
    STAT_MINIMUM_MARGIN_LEVEL = 26,
    STAT_CUSTOM_OPTIMIZATION_METRIC = 27,
    STAT_TOTAL_TRADES = 28,
    STAT_TOTAL_PROFITABLE_TRADES = 29,
    STAT_TOTAL_LOSING_TRADES = 30,
    STAT_TOTAL_SHORT_TRADES = 31,
    STAT_TOTAL_LONG_TRADES = 32,
    STAT_PROFIT_FROM_SHORT_TRADES = 33,
    STAT_PROFIT_FROM_LONG_TRADES = 34,
    STAT_AVG_CONSECUTIVE_PROFITS = 35,
    STAT_AVG_CONSECUTIVE_LOSSES = 36
}
export type TDateTime = number;
export type TColor = string;
export declare enum TObjectType {
    ANY_OBJECT = 0,
    V_LINE = 1,
    H_LINE = 2,
    TREND_LINE = 3,
    RAY = 4,
    POLYLINE = 5,
    FIBO_RETRACEMENT = 6,
    FIBO_TIME_ZONES = 7,
    FIBO_ARC = 8,
    FIBO_FAN = 9,
    ANDREWS_PITCHFORK = 10,
    TEXT = 11,
    TEXT_LABEL = 12,
    RECTANGLE = 13,
    ELLIPSE = 14,
    TRIANGLE = 15,
    FIBO_CHANNEL = 16,
    LR_CHANNEL = 17,
    FIBO_EXTENSION = 18,
    GANN_BOX = 19
}
export declare enum TimeValue {
    '00:00' = "00:00",
    '00:15' = "00:15",
    '00:30' = "00:30",
    '00:45' = "00:45",
    '01:00' = "01:00",
    '01:15' = "01:15",
    '01:30' = "01:30",
    '01:45' = "01:45",
    '02:00' = "02:00",
    '02:15' = "02:15",
    '02:30' = "02:30",
    '02:45' = "02:45",
    '03:00' = "03:00",
    '03:15' = "03:15",
    '03:30' = "03:30",
    '03:45' = "03:45",
    '04:00' = "04:00",
    '04:15' = "04:15",
    '04:30' = "04:30",
    '04:45' = "04:45",
    '05:00' = "05:00",
    '05:15' = "05:15",
    '05:30' = "05:30",
    '05:45' = "05:45",
    '06:00' = "06:00",
    '06:15' = "06:15",
    '06:30' = "06:30",
    '06:45' = "06:45",
    '07:00' = "07:00",
    '07:15' = "07:15",
    '07:30' = "07:30",
    '07:45' = "07:45",
    '08:00' = "08:00",
    '08:15' = "08:15",
    '08:30' = "08:30",
    '08:45' = "08:45",
    '09:00' = "09:00",
    '09:15' = "09:15",
    '09:30' = "09:30",
    '09:45' = "09:45",
    '10:00' = "10:00",
    '10:15' = "10:15",
    '10:30' = "10:30",
    '10:45' = "10:45",
    '11:00' = "11:00",
    '11:15' = "11:15",
    '11:30' = "11:30",
    '11:45' = "11:45",
    '12:00' = "12:00",
    '12:15' = "12:15",
    '12:30' = "12:30",
    '12:45' = "12:45",
    '13:00' = "13:00",
    '13:15' = "13:15",
    '13:30' = "13:30",
    '13:45' = "13:45",
    '14:00' = "14:00",
    '14:15' = "14:15",
    '14:30' = "14:30",
    '14:45' = "14:45",
    '15:00' = "15:00",
    '15:15' = "15:15",
    '15:30' = "15:30",
    '15:45' = "15:45",
    '16:00' = "16:00",
    '16:15' = "16:15",
    '16:30' = "16:30",
    '16:45' = "16:45",
    '17:00' = "17:00",
    '17:15' = "17:15",
    '17:30' = "17:30",
    '17:45' = "17:45",
    '18:00' = "18:00",
    '18:15' = "18:15",
    '18:30' = "18:30",
    '18:45' = "18:45",
    '19:00' = "19:00",
    '19:15' = "19:15",
    '19:30' = "19:30",
    '19:45' = "19:45",
    '20:00' = "20:00",
    '20:15' = "20:15",
    '20:30' = "20:30",
    '20:45' = "20:45",
    '21:00' = "21:00",
    '21:15' = "21:15",
    '21:30' = "21:30",
    '21:45' = "21:45",
    '22:00' = "22:00",
    '22:15' = "22:15",
    '22:30' = "22:30",
    '22:45' = "22:45",
    '23:00' = "23:00",
    '23:15' = "23:15",
    '23:30' = "23:30",
    '23:45' = "23:45",
    '23:59' = "23:59"
}
export declare enum TOptionType {
    LONGWORD = 0,
    INTEGER = 1,
    DOUBLE = 2,
    STRING = 3,
    BOOLEAN = 4,
    ENUM_TYPE = 5,
    TIMEFRAME = 6,
    CURRENCY = 7,
    LINE_STYLE = 8,
    SEPARATOR = 9,
    INDICATOR = 10,
    COLOR = 11,
    DATE_TIME = 12,
    LEVELS = 13,
    SESSION = 14,
    SESSIONS_ARRAY = 15,
    LINE = 16
}
export declare enum E_MAType {
    SMA = 0,
    EMA = 1,
    SMMA = 2,
    LWMA = 3
}
export declare abstract class TOptValue {
    abstract getLocalizationIndependentValue(): string;
    protected constructor();
}
export declare class TOptValue_str extends TOptValue {
    value: string;
    getLocalizationIndependentValue(): string;
    protected constructor(value: string);
}
export declare class TOptValue_number extends TOptValue {
    protected fValue: number;
    protected constructor(value: number);
    get value(): number;
    set value(value: number);
    getLocalizationIndependentValue(): string;
}
export declare class TOptValue_bool extends TOptValue {
    value: boolean;
    protected constructor(value: boolean);
    getLocalizationIndependentValue(): string;
}
export declare class TOptValue_LineStyleRec extends TOptValue {
    value: TLineStyleRec;
    protected constructor(value: TLineStyleRec);
    getLocalizationIndependentValue(): string;
}
export declare class TOptValue_DateTime extends TOptValue {
    value: TDateTime;
    protected constructor(value: TDateTime);
    getLocalizationIndependentValue(): string;
}
export declare enum TOutputWindow {
    CHART_WINDOW = 0,
    SEPARATE_WINDOW = 1
}
export declare enum MacdMode {
    MAIN = 0,
    SIGNAL = 1
}
export declare enum TPriceType {
    CLOSE = 0,
    OPEN = 1,
    HIGH = 2,
    LOW = 3,
    HL2 = 4,
    HLC3 = 5,
    HLCC4 = 6
}
export declare enum TValueType {
    OPEN = 0,
    HIGH = 1,
    LOW = 2,
    CLOSE = 3,
    VOLUME = 4
}
export declare class TOptValue_SessionsArray extends TOptValue {
    sessions: TOptValue_Session[];
    protected constructor(sessions: TOptValue_Session[]);
    getSessions(): TOptValue_Session[];
    toString(): string;
    getLocalizationIndependentValue(): string;
    static copyFromString(str: string): TOptValue_SessionsArray;
    static updateFromString(str: string, opt: TOptValue_SessionsArray): void;
}
export declare class TOptValue_Session extends TOptValue {
    isEnabled: boolean;
    name: string;
    startTime: TimeValue;
    endTime: TimeValue;
    color: string;
    protected constructor(isEnable: boolean, name: string, startTime: TimeValue, endTime: TimeValue, color: string);
    toString(): string;
    getLocalizationIndependentValue(): string;
    static copyFromString(str: string): TOptValue_Session;
    static updateFromString(str: string, opt: TOptValue_Session): void;
}
export declare class CurrencyInfo {
    symbol: string;
    digits: number;
    spread: number;
    point: number;
    lot: number;
    curr: string;
    swapLong: number;
    swapShort: number;
    protected constructor(symbol: string, digits: number, spread: number, point: number, lot: number, curr: string, swapLong: number, swapShort: number);
}
export interface IChartInterfaceProcRec {
    ConvertChartIndexToScreenX: (index: number) => number;
    ConvertPriceToScreenY: (price: number) => number;
    GetChartInformation: () => TChartInfo | null;
    RefreshChartDisplay: () => void;
}
export interface IVeryBasicProcRec {
}
export declare enum TimeUnit {
    SECONDS = 0,
    MILLISECONDS = 1
}
export declare enum TimeZoneMode {
    PROJECT = 0,
    UTC = 1
}
export declare class FTODate {
    private _date;
    private _timeZoneMode;
    protected constructor(value: string | number | Date, unit?: TimeUnit, timeZoneMode?: TimeZoneMode);
    valueOf(timeUnit?: TimeUnit): number;
    toMilliseconds(timeZoneMode?: TimeZoneMode): number;
    toSeconds(timeZoneMode?: TimeZoneMode): number;
    toString(timeZoneMode?: TimeZoneMode): string;
    toJSDate(timeZoneMode?: TimeZoneMode): Date;
    dayOfMonth(timeZoneMode?: TimeZoneMode): number;
    monthOf(timeZoneMode?: TimeZoneMode): number;
    weekOf(timeZoneMode?: TimeZoneMode): number;
    yearOf(timeZoneMode?: TimeZoneMode): number;
    dayOfYear(timeZoneMode?: TimeZoneMode): number;
    dayOfWeek(timeZoneMode?: TimeZoneMode): number;
    hour(timeZoneMode?: TimeZoneMode): number;
    minute(timeZoneMode?: TimeZoneMode): number;
    second(timeZoneMode?: TimeZoneMode): number;
    private convertByTimeZoneModeToMilliseconds;
    private calculateWeekOfYear;
}
export interface IDateTimeProcRec extends IVeryBasicProcRec {
    GetDayOfMonthByDateTime: (time: FTODate) => number;
    GetWeekByDateTime: (time: FTODate) => number;
    GetMonthByDateTime: (time: FTODate) => number;
    GetYearByDateTime: (time: FTODate) => number;
    TimeCurrent: () => FTODate;
    Day: () => number;
    DayOfWeek: () => number;
    DayOfYear: () => number;
    Hour: () => number;
    Minute: () => number;
    Month: () => number;
    Second: () => number;
    Year: () => number;
    StructToTime: (time: FTODate) => number;
    TimeDay: (unixTimeSeconds: number) => number;
    TimeDaylightSavings: () => number;
    TimeDayOfWeek: (unixTimeSeconds: number) => number;
    TimeDayOfYear: (unixTimeSeconds: number) => number;
    TimeGMT: () => number;
    TimeLocal: () => number;
    TimeGMTOffset: () => number;
    TimeHour: (unixTimeSeconds: number) => number;
    TimeMinute: (unixTimeSeconds: number) => number;
    TimeMonth: (unixTimeSeconds: number) => number;
    TimeSeconds: (unixTimeSeconds: number) => number;
    TimeYear: (unixTimeSeconds: number) => number;
}
export interface ICurrentSymbolAndTFInfoProcRec {
    Symbol: () => string;
    Timeframe: () => number;
    Bid: () => number;
    Ask: () => number;
    Digits: () => number;
    Point: () => number;
    Open: (index: number) => number;
    Close: (index: number) => number;
    High: (index: number) => number;
    Low: (index: number) => number;
    Volume: (index: number) => number;
    Time: (index: number, timeZoneMode?: TimeZoneMode) => FTODate;
    Bars: () => number;
    GetPrice: (index: number, priceType: TPriceType) => number;
    GetHighestValue: (ValueType: TValueType, StartIndex: number, count: number) => number;
    GetLowestValue: (ValueType: TValueType, StartIndex: number, count: number) => number;
}
export interface IOptionsProcRec {
    RegOption: (optionName: string, optionType: TOptionType, optionPtr: TOptValue) => void;
    SetOptionRange: (optionName: string, minValue: number, maxValue: number) => void;
    SetOptionDigits: (optionName: string, digits: number) => void;
    AddOptionValue: (optionName: string, value: string) => void;
    AddSeparator: (separatorName: string) => void;
    RegMATypeOption: (optionPtr: TOptValue, name?: string) => void;
    RegApplyToPriceOption: (optionPtr: TOptValue, name: string) => void;
}
export interface ITechnicalIndicatorsProcRec {
    iMACD: (symbol: string | null, timeframe: number | null, fastEmaPeriod: number, slowEmaPeriod: number, signalPeriod: number, appliedPrice: TPriceType, mode: MacdMode, index: number) => number;
    GetMA: (index: number, shift: number, period: number, maType: E_MAType, applyTo: TPriceType, prev?: number) => number;
    iMA: (symbol: string, timeframe: number, period: number, ma_shift: number, maMethod: E_MAType, appliedPrice: TPriceType, shift: number) => number;
    LRCChannelParams: (shift: number, period: number, priceType: TPriceType) => {
        StartValue: number;
        EndValue: number;
        Height: number;
        Top: number;
        Bottom: number;
    };
}
export interface ITimeseriesProcRec {
    iOpen: (symbol: string, timeframe: number, index: number) => number;
    iClose: (symbol: string, timeframe: number, index: number) => number;
    iHigh: (symbol: string, timeframe: number, index: number) => number;
    iLow: (symbol: string, timeframe: number, index: number) => number;
    iVolume: (symbol: string, timeframe: number, index: number) => number;
    iTime: (symbol: string, timeframe: number, index: number) => FTODate;
    iBars: (symbol: string, timeframe: number) => number;
    iBarShift: (symbol: string, timeframe: number, time: FTODate, exact: boolean) => number;
    iHighest: (symbol: string, timeframe: number, type: TValueType, count: number, index: number) => number;
    iLowest: (symbol: string, timeframe: number, type: number, count: number, index: number) => number;
    UpdateMarketPrices(): boolean;
}
export interface IIndexBuffer {
    GetMax(index1: number, index2: number, EmptyValue?: number): number;
    GetMin(index1: number, index2: number, EmptyValue?: number): number;
    GetValue(globalIndex: number): number;
    GetDateTime(globalIndex: number): TDateTime;
    GetValue_reversedIndex(lastItemEquals_0_based_index: number): number;
    IsEmpty(globalIndex: number): boolean;
    SetValue_reversedIndex(lastItemEquals_0_based_index: number, value: number | null): void;
    Clear(): void;
    HasSomeValues(): boolean;
    GetMaxPossibleGlobalIndex(): number;
    LastItemInTestingIndex: number;
    get shift(): number;
    set shift(value: number);
}
export declare class SelectionMarkers {
    step: number | null;
    selectionMarkersIndexes: number[];
    protected constructor(step: number | null, selectionMarkersIndexes: number[]);
}
export declare enum TIndexPos {
    VALID = 0,
    INVALID = 1,
    INV_BEFORE = 2,
    INV_AFTER = 3
}
export interface IVisibleIndexBuffer {
    isJumpableBufferType(): unknown;
    get index(): number;
    get buffer(): IIndexBuffer;
    set buffer(value: IIndexBuffer | null);
    name: string;
    PaintFrom: number;
    style: TLineStyleRec;
    selectionMarkers: SelectionMarkers;
    show(): void;
    hide(): void;
    IsVisible(): boolean;
    EmptyValue: number;
    Count: number;
    onIndicatorSelected(): void;
    onIndicatorUnselected(): void;
    IsSelected(): boolean;
    CheckIndex(index: number): TIndexPos;
    GetValue(index: number): number;
    getLastItemInTestingValue(): number;
}
export declare enum ObjProp {
    OBJPROP_TIME1 = 0,
    OBJPROP_PRICE1 = 1,
    OBJPROP_FILLCOLOR = 2,
    OBJPROP_COLOR = 3,
    OBJPROP_STYLE = 4,
    OBJPROP_WIDTH = 5,
    OBJPROP_TIME2 = 6,
    OBJPROP_PRICE2 = 7,
    OBJPROP_TIME3 = 8,
    OBJPROP_PRICE3 = 9,
    OBJPROP_LEVELVALUE = 10,
    OBJPROP_LEVELCOLOR = 11,
    OBJPROP_LEVELSTYLE = 12,
    OBJPROP_LEVELWIDTH = 13,
    OBJPROP_FONTNAME = 14,
    OBJPROP_FONTSIZE = 15,
    OBJPROP_NAME = 16,
    OBJPROP_FILLINSIDE = 17,
    OBJPROP_ELLIPSE = 18,
    OBJPROP_FIBOENDWIDTH = 19,
    OBJPROP_FIBOCLOSEDENDS = 20,
    OBJPROP_FIBOSHOWPRICE = 21,
    OBJPROP_FIBOLEVELS = 22,
    OBJPROP_SCREENCOORDS = 23,
    OBJPROP_TEXT = 24,
    OBJPROP_SCRHALIGNMENT = 25,
    OBJPROP_SCRVALIGNMENT = 26,
    OBJPROP_HALIGNMENT = 27,
    OBJPROP_YDISTANCE = 28,
    OBJPROP_VALIGNMENT = 29,
    OBJPROP_XDISTANCE = 30,
    OBJPROP_FIBOLEVELN = 31,
    BORDER = 32,
    OBJPROP_TEXT_PARAMS = 33,
    OBJPROP_MIDDLE_LINE = 34
}
export interface IObjectsProcRec {
    GetObjectName: (index: number, isStatic?: boolean) => string;
    CreateChartObject: (name: string, objType: TObjectType, window: number, time1: FTODate, price1: number, time2?: FTODate, price2?: number, time3?: FTODate, price3?: number, isStatic?: boolean) => boolean;
    RemoveChartObject: (name: string, isStatic?: boolean) => void;
    DoesChartObjectExist: (name: string, isStatic?: boolean) => boolean;
    GetObjectType: (name: string, isStatic?: boolean) => TObjectType;
    SetObjectProperty: (name: string, index: ObjProp, value: any, isStatic?: boolean) => boolean;
    GetObjectProperty: (name: string, index: ObjProp, isStatic?: boolean) => number | string;
    GetObjectNumberProperty: (name: string, index: ObjProp, isStatic?: boolean) => number;
    GetObjectStringProperty: (name: string, index: ObjProp, isStatic?: boolean) => string;
    RemoveAllObjects: (objType: TObjectType, isStatic?: boolean) => void;
    SetObjectText: (name: string, text: string, fontSize?: number, fontName?: string, color?: TColor, isStatic?: boolean) => boolean;
    GetObjectText: (name: string, isStatic?: boolean) => string;
    GetObjectCount: (isStatic?: boolean) => number;
    GetObjectDescription: (name: string, isStatic?: boolean) => string;
    FindObject: (chartId: number | null, objectName: string) => number;
    GetObjectEnumProperty: (chartId: number, objectName: string, propId: number, propModifier?: number) => number;
    GetFibonacciDescription: (objectName: string, index: number) => string;
    MoveObject: (objectName: string, pointIndex: number, time: number, price: number) => boolean;
    SetObjectEnumProperty: (chartId: number, objectName: string, propId: number, propModifier: number, propValue: number) => void;
    SetFibonacciDescription: (objectName: string, index: number, text: string) => boolean;
    GetTextDimensions: (text: string) => {
        width: number;
        height: number;
    };
}
export interface IDataInfoProcRec {
    GetSymbolInfo: (symbolName: string) => CurrencyInfo | null;
}
export interface ITestingProcRec {
    IsInTestingMode: () => boolean;
    IsExecutionPaused: () => boolean;
}
export interface IAccountInfoProcRec {
    GetAccountBalance: () => number;
    GetAccountEquity: () => number;
    GetAccountMargin: () => number;
    GetAvailableMargin: () => number;
    GetLeverageRatio: () => number;
    GetCurrentProfit: () => number;
    GetAccountNumberProperty: (propertyId: number) => number;
    GetAccountStringProperty: (propertyId: number) => string;
    GetBrokerName: () => string;
    GetAccountCurrency: () => string;
    CheckMarginRequirement: (symbol: string, cmd: number, volume: number) => number;
    GetAccountName: () => string;
}
export interface IErrorHandlingProcRec {
    GetLastError: () => string;
    SetLastError: (error: string) => void;
    ResetLastError: () => void;
}
export interface ICommonFunctionsProcRec {
    Alert: (...args: any[]) => void;
    Print: (...args: any[]) => void;
    CheckPointer: (...args: unknown[]) => void;
    Comment: (...args: unknown[]) => void;
    CryptEncode: (...args: unknown[]) => void;
    CryptDecode: (...args: unknown[]) => void;
    ExpertRemove: (...args: unknown[]) => void;
    GetTickCount: (...args: unknown[]) => number;
    MessageBox: (...args: unknown[]) => void;
    PeriodSeconds: (period: ENUM_TIMEFRAMES) => number;
    Sleep: (milliseconds: number) => void;
    TesterStatistics: (statistic_id: ENUM_STATISTICS) => number;
    ZeroMemory: <T>(variable: T) => void;
    Is_A_lessThan_b(a: number, b: number): boolean;
    Is_A_greaterThan_b(a: number, b: number): boolean;
}
export interface Tick {
    time: number;
    bid: number;
    ask: number;
    last: number;
    volume: number;
}
export interface IMarketInfoProcRec {
    GetMarketInformation(symbol: string, type: number, positionType?: TTradePositionType): number;
    GetAvailableSymbolCount(): number;
    GetSymbolName(index: number): string;
    SelectTradingSymbol(name: string, select: boolean): boolean;
    GetSymbolNumberProperty(name: string, prop_id: ENUM_SYMBOL_INFO_NUMBER): number;
    GetSymbolStringProperty(name: string, prop_id: ENUM_SYMBOL_INFO_STRING): string;
    GetSymbolTickInfo(symbol: string, tickData: Tick): boolean;
    GetLastProcessedTickTime(symbol: string): FTODate;
}
export interface IUtilFactoriesProcRec {
    createFTODate: (value: string | number | Date, unit?: TimeUnit, timeZoneMode?: TimeZoneMode) => FTODate;
    createTOptValue_SessionsArray: (sessions: TOptValue_Session[]) => TOptValue_SessionsArray;
    createTOptValue_Session: (isEnabled: boolean, name: string, startTime: TimeValue, endTime: TimeValue, color: string) => TOptValue_Session;
    createTOptValue_DateTime: (value: TDateTime) => TOptValue_DateTime;
    createTOptValue_bool: (value: boolean) => TOptValue_bool;
    createTOptValue_LineStyleRec: (value: TLineStyleRec) => TOptValue_LineStyleRec;
    createTOptValue_str: (value: string) => TOptValue_str;
    createTOptValue_number: (value: number) => TOptValue_number;
}
export interface ISharedProcRec extends ITechnicalIndicatorsProcRec, ITimeseriesProcRec, IDateTimeProcRec, IOptionsProcRec, ICurrentSymbolAndTFInfoProcRec, IChartInterfaceProcRec, IObjectsProcRec, IDataInfoProcRec, ITestingProcRec, IAccountInfoProcRec, IErrorHandlingProcRec, ICommonFunctionsProcRec, IMarketInfoProcRec, IUtilFactoriesProcRec {
}
export declare class TVisibleBufferInfo {
    buffer: TIndexBuffer | null;
    name: string;
    paintFrom: number;
    protected constructor(visibleBufferInfo: IVisibleIndexBuffer);
}
export declare class TIndexBuffer {
    private programSideBuffer;
    protected constructor(programSideBuffer: IIndexBuffer);
    getBuffer(): IIndexBuffer;
    setValue(index: number, price: number): void;
    getValue(index: number): number;
}
interface IIndicatorsProcRec extends ISharedProcRec {
    IndicatorDigits: (digits: number) => void;
    IndicatorShortName: (shortName: string) => void;
    SetOutputWindow: (outputWindow: TOutputWindow) => void;
    SetEmptyValue: (emptyValue: number) => void;
    Counted_bars: () => number;
    SetIndicatorIdKey: (key: string) => void;
    SetFixedMinMaxValues: (aMin: number, aMax: number) => void;
    RecalculateMeAlways: () => void;
    SetBackOffsetForCalculation: (offset: number) => void;
    AddLevel: (value: number, style: TPenStyle, width: number, color: TColor, opacity: number) => void;
    SetLevelValue: (index: number, value: number) => void;
    IndicatorBuffers: (bufferCount: number) => void;
    CreateIndexBuffer: () => TIndexBuffer;
    CreateIndexBufferWithArgs: (index: number, aLabel: string, drawStyle: TDrawStyle, style: TPenStyle, width: number, color: TColor) => TIndexBuffer;
    SetIndexBuffer: (bufferIndex: number, buffer: TIndexBuffer) => void;
    SetIndexStyle: (bufferIndex: number, type: TDrawStyle, style: TPenStyle, width: number, clr: TColor, isVisible?: boolean) => void;
    SetIndexSymbol: (bufferIndex: number, symbol: number, xoffs: number, yoffs: number) => void;
    SetIndexLabel: (bufferIndex: number, bufferName: string) => void;
    SetIndexVisibility: (index: number, isVisible: boolean) => void;
    GetBufferValue: (buffer: number, index: number) => number;
    SetBufferValue: (buffer: number, index: number, value: number) => void;
    GetBufferCount: (buffer: number) => number;
    GetBufferMax: (buffer: number, index1: number, index2: number) => number;
    GetBufferMin: (buffer: number, index1: number, index2: number) => number;
    GetBufferInfo: (index: number) => TVisibleBufferInfo;
    SetIndexDrawBegin: (bufferIndex: number, PaintFrom: number) => void;
    SetBufferShift: (bufferIndex: number, shift: number) => void;
}
export type { IIndicatorsProcRec as default };
